from mongoengine import Document, StringField, DateTimeField, DictField, BooleanField, ReferenceField
from datetime import datetime
import uuid


class SessionLog(Document):
    """Session Log model for tracking user sessions"""
    meta = {'collection': 'session_logs'}

    session_log_id = StringField(required=True, unique=True, default=lambda: str(uuid.uuid4()))
    user_id = StringField(required=True)
    access_token = StringField(required=True)
    refresh_token = StringField(required=True)
    device_type = StringField()  # mobile, web, tablet
    device_fingerprint = StringField()
    mac_id = StringField()
    ip_address = StringField()
    user_agent = StringField()
    location = DictField()  # {lat, lng}
    timezone = StringField()
    is_active = BooleanField(default=True)
    login_at = DateTimeField(default=datetime.utcnow)
    logout_at = DateTimeField()
    expires_at = DateTimeField()
    created_at = DateTimeField(default=datetime.utcnow)
    updated_at = DateTimeField(default=datetime.utcnow)

    def __repr__(self):
        return f'<SessionLog {self.session_log_id}>'
