from datetime import datetime
import uuid


def success_response(message, data=None, status_code=200, request_id=None, action_log_id=None):
    """Generate standardized success response"""
    return {
        "status": "success",
        "status_code": status_code,
        "message": message,
        "data": data or {},
        "meta": {
            "request_id": request_id or str(uuid.uuid4()),
            "action_log_id": action_log_id or str(uuid.uuid4()),
            "timestamp": datetime.utcnow().isoformat() + "Z"
        }
    }, status_code


def error_response(message, error_code, error_details=None, status_code=400, request_id=None, action_log_id=None):
    """Generate standardized error response"""
    return {
        "status": "failed",
        "status_code": status_code,
        "message": message,
        "error": {
            "code": error_code,
            "details": error_details or message
        },
        "meta": {
            "request_id": request_id or str(uuid.uuid4()),
            "action_log_id": action_log_id or str(uuid.uuid4()),
            "timestamp": datetime.utcnow().isoformat() + "Z"
        }
    }, status_code
